/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen.form;

import com.google.common.math.IntMath;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.AARotation;
import qouteall.q_misc_util.my_util.IntBox;
import qouteall.q_misc_util.my_util.IntMatrix3;

public class DiligentMatcher {
    public static List<TransformedShape> getMatchableShapeVariants(BlockPortalShape original, int maxShapeLen) {
        ArrayList<TransformedShape> result = new ArrayList<TransformedShape>();
        HashSet<BlockPortalShape> shapeSet = new HashSet<BlockPortalShape>();
        int divFactor = DiligentMatcher.getShapeShrinkFactor(original);
        BlockPortalShape shrinked = DiligentMatcher.shrinkShapeBy(original, divFactor);
        int shrinkedShapeLen = shrinked.getShapeInnerLength();
        int maxMultiplyFactor = (int)Math.floor((double)maxShapeLen / (double)shrinkedShapeLen);
        for (AARotation rotation : AARotation.rotationsSortedByAngle) {
            IntMatrix3 rotationMatrix = rotation.matrix;
            BlockPortalShape rotatedShape = DiligentMatcher.rotateShape(shrinked, rotationMatrix);
            BlockPortalShape newShape = DiligentMatcher.regularizeShape(rotatedShape);
            boolean isNew = shapeSet.add(newShape);
            if (!isNew) continue;
            result.add(new TransformedShape(original, newShape, rotationMatrix, 1.0 / (double)divFactor));
            for (int mul = 2; mul <= maxMultiplyFactor; ++mul) {
                BlockPortalShape expanded = DiligentMatcher.regularizeShape(DiligentMatcher.upscaleShape(rotatedShape, mul));
                isNew = shapeSet.add(expanded);
                if (!isNew) continue;
                result.add(new TransformedShape(original, expanded, rotationMatrix, (double)mul / (double)divFactor));
            }
        }
        return result;
    }

    public static BlockPortalShape regularizeShape(BlockPortalShape rotatedShape) {
        return rotatedShape.getShapeWithMovedAnchor(BlockPos.f_121853_);
    }

    public static BlockPortalShape rotateShape(BlockPortalShape shape, IntMatrix3 t) {
        Set<BlockPos> newArea = shape.area.stream().map(b -> t.transform((Vec3i)b)).collect(Collectors.toSet());
        Direction.Axis newAxis = t.transformDirection(Direction.m_122387_((Direction.Axis)shape.axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)).m_122434_();
        return new BlockPortalShape(newArea, newAxis);
    }

    public static int getShapeShrinkFactor(BlockPortalShape shape) {
        HashSet<BlockPos> area = new HashSet<BlockPos>(shape.area);
        ArrayList<IntBox> boxList = DiligentMatcher.decomposeShape(shape, area);
        IntArrayList sideLenList = new IntArrayList();
        Tuple<Direction.Axis, Direction.Axis> axs = Helper.getAnotherTwoAxis(shape.axis);
        for (IntBox box : boxList) {
            BlockPos boxSize = box.getSize();
            int a2 = Helper.getCoordinate((Vec3i)boxSize, (Direction.Axis)axs.m_14418_());
            int b2 = Helper.getCoordinate((Vec3i)boxSize, (Direction.Axis)axs.m_14419_());
            sideLenList.add(a2);
            sideLenList.add(b2);
        }
        return (Integer)sideLenList.stream().reduce((a, b) -> IntMath.gcd((int)a, (int)b)).get();
    }

    public static BlockPortalShape shrinkShapeBy(BlockPortalShape shape, int div) {
        Validate.isTrue((div != 0 ? 1 : 0) != 0);
        BlockPortalShape regularized = DiligentMatcher.regularizeShape(shape);
        if (div == 1) {
            return regularized;
        }
        Set<BlockPos> newArea = regularized.area.stream().map(b -> new BlockPos(Math.floorDiv(b.m_123341_(), div), Math.floorDiv(b.m_123342_(), div), Math.floorDiv(b.m_123343_(), div))).collect(Collectors.toSet());
        return new BlockPortalShape(newArea, regularized.axis);
    }

    public static ArrayList<IntBox> decomposeShape(BlockPortalShape shape, HashSet<BlockPos> area) {
        IntBox box;
        ArrayList<IntBox> boxList = new ArrayList<IntBox>();
        while (!area.isEmpty() && (box = DiligentMatcher.splitBoxFromArea(area, shape.axis)) != null) {
            boxList.add(box);
        }
        return boxList;
    }

    public static BlockPortalShape upscaleShape(BlockPortalShape shape, int multiplyFactor) {
        Tuple<Direction.Axis, Direction.Axis> axs = Helper.getAnotherTwoAxis(shape.axis);
        Vec3i v1 = Direction.m_122387_((Direction.Axis)((Direction.Axis)axs.m_14418_()), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).m_122436_();
        Vec3i v2 = Direction.m_122387_((Direction.Axis)((Direction.Axis)axs.m_14419_()), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).m_122436_();
        return new BlockPortalShape(shape.area.stream().flatMap(basePos -> IntStream.range(0, multiplyFactor).boxed().flatMap(dx -> IntStream.range(0, multiplyFactor).mapToObj(dy -> Helper.scale((Vec3i)basePos, multiplyFactor).m_121955_((Vec3i)Helper.scale(v1, dx).m_121955_((Vec3i)Helper.scale(v2, dy)))))).collect(Collectors.toSet()), shape.axis);
    }

    private static IntBox splitBoxFromArea(Set<BlockPos> area, Direction.Axis axis) {
        Iterator<BlockPos> iterator = area.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        BlockPos firstElement = iterator.next();
        IntBox expanded = Helper.expandRectangle(firstElement, area::contains, axis);
        expanded.stream().forEach(b -> area.remove(b));
        return expanded;
    }

    public static class TransformedShape {
        public final BlockPortalShape originalShape;
        public final BlockPortalShape transformedShape;
        public final IntMatrix3 rotation;
        public final double scale;

        public TransformedShape(BlockPortalShape originalShape, BlockPortalShape transformedShape, IntMatrix3 rotation, double scale) {
            this.originalShape = originalShape;
            this.transformedShape = transformedShape;
            this.rotation = rotation;
            this.scale = scale;
        }
    }
}

